﻿//varibles for the session warning
var SessionTimeoutMinutes; // total time till the session should timeout in minutes
var SessionTimoutWarningMinutes;// total time till the warning should be displayed in minutes
var SessionTimoutWarningDurationMinutes = 1;// the amount of time that the warning should be displayed in minutes
var MinutesToMilliseconds = 60000; // minutes to milliseconds conversion variable
var SessionIntervalID; // var to hold the Interval 
var SessionLastActive; // var to tracks the last user interaction

function CheckAlpha(event) {
    if (event != null) {
        var code = event.which || event.keyCode;
        if (code != null) {
            //spacebar and dash, comma, period and numbers and A-Z and a-z
            if (code == 32 || (code >= 44 && code <= 46) || (code >= 48 && code <= 57) || (code >= 65 && code <= 90) || (code >= 97 && code <= 122))
                return true;
            else
                return false;
        }
    }

    return true;
}

function CheckNumeric(event)
{
    if (event != null)
    {
        var code = event.which || event.keyCode;
        if (code != null) {
            //0-9
            if (code >= 48 && code <= 57)
                return true;
            else
                return false;
        }
    }

    return true;
}

function CheckDate(event) {
    if (event != null) {
        var code = event.which || event.keyCode;
        if (code != null) {
            //0-9 and /
            if (code >= 47 && code <= 57)
                return true;
            else
                return false;
        }
    }

    return true;
}

//Moved here from Master Page
function setHourglass() {
    document.body.style.cursor = 'wait';
}

//Add titles to header sort hyperlinks and footer pager hyperlinks
function UpdateGridView(gridViewID) {
    var gridView = document.getElementById(gridViewID);
    if (gridView != null) {
        for (var i = 0; i < gridView.rows.length; i++) {
            var cells = gridView.rows[i].cells;
            if (cells != null) {
                if (i == 0) {
                    for (var j = 0; j < cells.length; j++) {
                        var links = cells[j].getElementsByTagName("a");
                        if (links != null) {
                            for (var k = 0; k < links.length; k++) {
                                links[k].title = "Column header, select to sort by " + links[k].innerHTML;
                            }
                        }
                    }
                }
                else if (i == (gridView.rows.length - 1)) {
                    var blnNumbers = false;
                    for (var j = 0; j < cells.length; j++) {
                        var links = cells[j].getElementsByTagName("a");
                        if (links != null) {
                            for (var k = 0; k < links.length; k++) {
                                if (links[k].innerHTML == "First Page") {
                                    links[k].title = "Select to go to the First Page";
                                }
                                else if (links[k].innerHTML == "Last Page") {
                                    links[k].title = "Select to go to the Last Page";
                                }
                                else if (links[k].innerHTML == "...") {
                                    if (blnNumbers) {
                                        links[k].title = "Select to go to the next group of pages";
                                    }
                                    else {
                                        links[k].title = "Select to go to the previous group of pages";
                                    }
                                }
                                else {
                                    blnNumbers = true;
                                    links[k].title = "Select to go to page " + links[k].innerHTML;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

// added for session timeout warning functions
//Set the  session timout and warning durations from web.config sessionState timeout passed from pageload
function InitSessionChecking(timeout) {
    SessionTimeoutMinutes = timeout;
    SessionTimoutWarningMinutes = SessionTimeoutMinutes - SessionTimoutWarningDurationMinutes;
    ResetSessionInterval();
    return false;
}

//resets the active timmer, and resets the interval checker
function ResetSessionInterval() {
    if (!IsSessionWarningDisplayed()) {
        SessionLastActive = new Date();
        ClearSessionInterval();
        SetIntervalCheck()
    }
    return false;
}

//sets the interval checker
function SetIntervalCheck() {
    SessionIntervalID = setInterval('SessionIntervalTimeoutCheck()', MinutesToMilliseconds)
}

//clears the interval checker
function ClearSessionInterval() {
    if (SessionIntervalID) {
        clearInterval(SessionIntervalID);
    }
}

//redirect the page to the logout link 
function LogUserOut() {
    var loggoutLink = document.getElementById("linkSSOiLogout");
    if (loggoutLink) {
        loggoutLink.click();
    }
    return false;
}

//resets the timer when the user selects ok on the warning message
function KeepUserActive()
{
    RemoveSessionTimoutWarning()
    ResetSessionInterval()
    return false;
}

//check to see if the warning is displayed
function IsSessionWarningDisplayed() {
    var warningWindow = document.getElementById("divTimeoutWindow");
    if (warningWindow && warningWindow.style.display != 'block') {
        return false;
    }

    return true;
}

//changes the warning message's display state to block
function DisplaySessionTimoutWarning() {
    var warningWindow = document.getElementById("divTimeoutWindow");
    if (warningWindow && warningWindow.style.display != 'block')
    {
        warningWindow.style.display = 'block'
    }
    return false;
}

//changes the warning message's display state to none
function RemoveSessionTimoutWarning() {
    var warningWindow = document.getElementById("divTimeoutWindow");
    if (warningWindow) {
        warningWindow.style.display = 'none'
    }
    return false;
}

//check to see if the last active timer is old enough to trigger the warning message or the session logout
function SessionIntervalTimeoutCheck() {
    var now = new Date();
    var minutesSinceLastActive = ((now - SessionLastActive) / MinutesToMilliseconds);
    ClearSessionInterval()

    if (minutesSinceLastActive < SessionTimeoutMinutes) {
        if (minutesSinceLastActive > SessionTimoutWarningMinutes) {
            DisplaySessionTimoutWarning();
        }
        SetIntervalCheck();
    }
    else {
        LogUserOut()
    }
    return false;
}